/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.util;

import com.yungnickyoung.minecraft.betterstrongholds.util.BannerPattern;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.WallBannerBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class Banner {
    private List<BannerPattern> patterns;
    private BlockState state;
    private CompoundNBT nbt;
    private boolean isWallBanner;

    public Banner(List<BannerPattern> _patterns, BlockState _state, CompoundNBT _nbt) {
        this.patterns = _patterns;
        this.state = _state;
        this.nbt = _nbt;
        this.isWallBanner = this.state.func_177230_c() instanceof WallBannerBlock;
    }

    public Banner(List<BannerPattern> _patterns, BlockState _state, CompoundNBT _nbt, boolean _isWallBanner) {
        this.patterns = _patterns;
        this.state = _state;
        this.nbt = _nbt;
        this.isWallBanner = _isWallBanner;
    }

    public List<BannerPattern> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<BannerPattern> patterns) {
        this.patterns = patterns;
    }

    public BlockState getState() {
        return this.state;
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public CompoundNBT getNbt() {
        return this.nbt;
    }

    public void setNbt(CompoundNBT nbt) {
        this.nbt = nbt;
    }

    public boolean isWallBanner() {
        return this.isWallBanner;
    }

    public void setWallBanner(boolean wallBanner) {
        this.isWallBanner = wallBanner;
    }

    public static class Builder {
        private final List<BannerPattern> patterns = new ArrayList<BannerPattern>();
        private BlockState state = Blocks.field_196873_hy.func_176223_P();

        public Builder blockState(BlockState state) {
            this.state = state;
            return this;
        }

        public Builder pattern(BannerPattern pattern) {
            this.patterns.add(pattern);
            return this;
        }

        public Builder pattern(String pattern, int color) {
            this.patterns.add(new BannerPattern(pattern, color));
            return this;
        }

        public Banner build() {
            CompoundNBT nbt = Builder.createBannerNBT(this.patterns);
            return new Banner(this.patterns, this.state, nbt);
        }

        private static CompoundNBT createBannerNBT(List<BannerPattern> patterns) {
            CompoundNBT nbt = new CompoundNBT();
            ListNBT patternList = new ListNBT();
            for (BannerPattern pattern : patterns) {
                CompoundNBT patternNBT = new CompoundNBT();
                patternNBT.func_74778_a("Pattern", pattern.getPattern());
                patternNBT.func_74768_a("Color", pattern.getColor());
                patternList.add((Object)patternNBT);
            }
            nbt.func_218657_a("Patterns", (INBT)patternList);
            nbt.func_74778_a("id", "minecraft:banner");
            return nbt;
        }
    }
}

